#!/bin/sh
# --------------------------------------------------------------------------
# Ort: /home/lzh/bin/
#
# Modifiziert 	jkr : 2017-08-10 Pruefe auf root-Rechte
# --------------------------------------------------------------------------
# Exitcodes:
# 0     - Erfolgreich beendet.
#
# 1     - Skript unerwartet beendet (Ctrl^C, kill, Shell geschlossen etc.).
#         ACHTUNG:
#         In diesem Fall ist die Installation zu wiederholen
#
# 2     - Benutzer ist nicht root (EUID=0). 
#         Vor dem Ausfuehren des Skriptes 
#         zu Benutzer root wechseln mit Befehl: su - root 
#
# 3     - nicht verwendet...
# 4     - Abbruch
#
# --------------------------------------------------------------------------
# Benutzung des Skriptes anzeigen bei falscher Benutzung.
print_usage () {
 echo 
 echo Aufruf: $0 \<Objektverzeichnis\> [\<Objektpfad\>]
 echo
 echo Beispiel: $0 BODD
 echo \-\> GA-Knoten fuer 'BODD' aus Verzeichnis '/home/lzh/gak_import/bodd' erstellen.
 echo Hinweis: 
 echo Die ersten vier Zeichen des 1. Parameters \(Objektverzeichnis\) werden 
 echo zur Bildung des Objektnames automatisch in Grossbuchstaben umgewandelt.
 echo Objektname fehlt!
 echo Verlasse Skript mit Exitcode = 1.
 exit 1                               # Exitcode 1: Parameter falsch angegeben.
}
# Starte das Skript.
echo
echo Starte Skript \'$0\' mit $# Parameter\(n\).

. /etc/profile
#. /home/lzh/.bashrc

# Kommandozeilenparameter
# Wenn erster Parameter Laenge 0 (= nicht existiert) hat, abbrechen
if test -z $1; then
 echo Fehler: Paramater falsch angegeben. Bitte beachten Sie die folgenden Hinweise: 
 print_usage;
exit 1
fi

# Wenn erster Parameter kuerzer als 4 (minimale Laenge Objektname) ist, abbrechen:
OBJEKT_LENGTH=`expr length $1`			# Laenge des ersten Parameters $1 ermitteln.
if [ $OBJEKT_LENGTH -lt 4 ]; then
 echo Fehler: Laenge des ersten Parameters ist kleiner als vier: $1
 echo Verlasse Skript mit Exitcode = 2.
 exit 2					# Exitcode 2: Objektname zu kurz.
fi

# Wenn bis hier gekommen, ist Parameter 1 korrekt und kann ausgewertet werden.
OBJEKT_DIR=$1
OBJEKT=`echo ${OBJEKT_DIR:0:4}` 		# Erste vier Buchstaben als Objektname verwenden
echo Objektverzeichnis: $OBJEKT_DIR
echo Objektname: $OBJEKT

echo
echo "############### GA-Knoten auf OpenSuse 11.4 #############################"
echo "#                                                                       #"
echo "# Installiert einen GA-Knoten                                           #"
echo "# Ausfuehren im Verzeichnis als Benutzer root:                          #"
echo "# Quellstruktur      : /home/lzh/bin/                                   #"
echo "# Zielstruktur       : /home/lzh/gak_import/                            #"
echo "# Ausfuehren als     : root                                             #"
echo "# Uebergabeparameter : xxxx    (xxxx:= Objekt mit 4 Zeichen)            #"
echo "#                          z.B. AMEV                                    #"
echo "# Nachfolgend beantworten mit j oder n (ja/nein)                        #"
echo "#                                                                       #"
echo "# Authors            : Energie- & Umweltbuero e.V., jkr                 #"
echo "#                                                                       #"
echo "######################################################### (c)EUB 2018 ###"
echo "#  Starte das Skript                                                    #"
#echo "#  --> $0 "
wait
    while : # Null-Befehl (immer wahr)
    do
           echo -n "Installieren [j|n] ? "
           # read: Zeile von StdIn einlesen

           read line 
           case "$line" in
                j|ja|J|Ja|JA|y|yes|Y|Yes|YES)     echo "Installation starten."
                                              
                                                  break;;
                n|nein|N|Nein|NEIN|n|no|N|No|NO)  echo "Abbruch mit Exitcode 4" 
                                                  exit 4
                                                  break;;
                *)  echo 
                    echo "Fehler: Bitte mit j(a) oder n(ein) antworten!" ;;
           esac
    done
echo Aufruf: $0 \<Objektverzeichnis\> [\<Objektpfad\>]
wait

#
#
# Globale Variablen
scriptname=`basename $0`
path=`pwd`
scripttitle="7_installiere-gaknoten.sh"
pfadvon="/home/lzh/bin/"
pfadgak="/home/lzh/gak_import/$OBJEKT    #erzeuge_gaknoten"
echo "Benutzer aktuell: " 
whoami
cd $pfadgak
echo "im Verzeichnis "  $pfadvon
 
##------------------------------------------------------------------------------
# jkr_2016-11-10: Root-Rechte bestimmen
echo " "
echo -n "Auf root-Rechte pruefen: "
if [ $EUID -ne 0 ]; then
    echo
    echo "***Fehler***: NICHT angemeldet als Benutzer root "
    echo
    echo "Das Skript > sh $0 "
    echo "muss als Benutzer  root "
    echo "und im Verzeichnis "$pfadvon
    echo "ausgefuehrt werden!"
    echo
    echo "Es wird jetzt ein Terminal geöffnet als Benutzer root"
    echo "(weiter mit Enter Tast)"
    read line 
    echo "Bitte das Passwort eintippen"
    echo "Ein Neustart erfolgt im Terminal nach der Passwort-Eingabe"
    echo "indem Sie folgenden Befehl eintippen:"
    echo $scripttitle $OBJEKT
    su 
    read line 
 exit 2
fi
echo "OK"
##------------------------------------------------------------------------------
# mh_2013-01-04: Benutzernamen bestimmen
objekt_path=`basename $path`

##------------------------------------------------------------------------------
# Nur ausfuehren, wenn 
if [ $scriptname == $scripttitle ]
then
   echo "erzeuge gaknoten"
   echo wait
   erzeuge_gaknoten
  
fi
##------------------------------------------------------------------------------
echo "######################################################### (c)EUB 2017 ###"

echo wait
exit 0


